/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

//from shadertoy ./. gigatron 
#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;

#define M_PI 3.1415926535897932384626433832795

float rand(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main()
{
	float size = 30.0;
	float prob = 0.85;
	
	vec2 pos = floor(1.0 / size * scaled_gl_FragCoord.xy);
	
	float color = 0.0;
	float starValue = rand(pos);
	
	if (starValue > prob)
	{
		vec2 center = size * pos + vec2(size, size) * 0.5;
		
		float t = 0.9 + 0.2 * sin(time *8.0+ (starValue - prob) / (1.0 - prob) * 45.0);
				
		color = 1.0 - distance(scaled_gl_FragCoord.xy, center) / (0.5 * size);
		color = color * t / (abs(scaled_gl_FragCoord.y - center.y)) * t / (abs(scaled_gl_FragCoord.x - center.x));
		 
		 
	}
	else if (rand(scaled_gl_FragCoord.xy / resolution.xy) > 0.996)
	{
		float r = rand(scaled_gl_FragCoord.xy);
		color = (0.85 * sin(time * (r * 5.0) + 720.0 * r) + 0.95);
	}
	
	
	gl_FragColor = vec4(vec3(color),1.0);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}

